<?php

namespace VM\AdminBundle\Controller;

use Import\ApiBundle\Entity\GpwIndex;
use Import\ApiBundle\Entity\GpwSession;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\AdminBundle\Services\ApiGetter;

class IndicatorsController extends AbstractController
{
    /**
     * @View(serializerGroups={"indicatorsDetails"})
     */
    public function getAction()
    {
        $results = array();

        //odsetki od zaległości podatkowych
        $results['interest'] = $this->getInterest();
        $results['incomeTaxRates'] = $this->getIncomeTaxRates();
        $results['paymentAvg'] = $this->getPaymentAvg();
        $results['paymentMin'] = $this->getPaymentMin();
        $results['delegations'] = $this->getDelegations();
        $results['vehicle_cost'] = $this->getDoctrine()->getRepository('ImportApiBundle:VehicleCost')->findAll();
        $results['zus'] = $this->getZUS();



        return $results;
    }

    private function getInterest()
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:Interest')->getLastInterest();
    }

    private function getIncomeTaxRates()
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:IncomeTaxRate')->getLastIncomeTaxRate();
    }

    private function getPaymentAvg()
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:PaymentAvg')->getLastAvgPayment();
    }

    private function getPaymentMin()
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:PaymentMin')->getLastMinPayment();
    }

    private function getDelegations()
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:DelegationCost')->findAll();
    }

    private function getZUS()
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:ContributionZUS')->createQueryBuilder('c')
            ->orderBy('c.yearFrom', 'DESC')
            ->addOrderBy('c.monthFrom', 'DESC')
            ->setMaxResults(1)
            ->getQuery()
            ->getSingleResult()
        ;
    }
}
